<?php
session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['work_position'] !== 'valdes_loceklis') {
    header("Location: ../html/log-in.html");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Owner Dashboard</title>
    <link rel="stylesheet" href="../css/owner-dashboard.css">
</head>
<body>
<header>
    <nav>
        <ul>
            <li><a href="../php/owner-dashboard.php" class="active">Dashboard</a></li>
            <li><a href="../php/profile.php">Profile</a></li>
            <li><a href="../php/logout.php">Logout</a></li>
        </ul>
    </nav>
</header>
<main>
    <h1>Welcome, <?php echo htmlspecialchars($_SESSION['first_name']); ?>!</h1>
    <div>
        <label for="worker-dropdown">Select a Worker:</label>
        <select id="worker-dropdown">
            <option value="">-- Select a Worker --</option>
        </select>
    </div>
    <div class="table-container">
        <table>
            <thead>
            <tr>
                <th>Date</th>
                <th>Clock In</th>
                <th>Clock Out</th>
                <th>Total Hours</th>
            </tr>
            </thead>
            <tbody id="work-hours-table">
            <tr>
                <td colspan="4">Select a worker to view their hours</td>
            </tr>
            </tbody>
        </table>
    </div>
</main>
<script src="../js/owner-dashboard.js"></script>
</body>
</html>
